// multitexture texture version of tcGen.inc

uniform	vec2	u_tgen;
uniform	vec3	u_parmtc;
uniform	vec3	u_tcGenVectorS[2];	// 2 = NUM_TEXTURE_BUNDLES
uniform	vec3	u_tcGenVectorT[2];	// 2 = NUM_TEXTURE_BUNDLES
uniform	float	u_tcModParms[53];	// NUM_TEXTURE_BUNDLES * TR_MAX_TEXMODS * 6 + TR_MAX_TEXMODS + 1

#define	TCGEN_TEXTURE			1.0
#define	TCGEN_LIGHTMAP			2.0
#define	TCGEN_ENVIRONMENT_MAPPED	3.0
#define	TCGEN_FOG			4.0
#define	TCGEN_VECTOR			5.0

#define	GLSL_TMOD_NONE			0.0
#define	GLSL_TMOD_TURBULENT		1.0
#define	GLSL_TMOD_MATRIX		2.0

void tcGen(out vec2 st0, out vec2 st1, in vec4 glVertex)
{
	int	b;
	vec2	st[2];
	float	tgen[2];

	tgen[0] = u_tgen.x;
	tgen[1] = u_tgen.y;
	int tcOffs = 0;

	for ( b = 0; b < 2; b++ )	// 2 = NUM_TEXTURE_BUNDLES
	{
		// texGen
		st[b] = vec2(0.0);		// TCGEN_BAD (default) shut up compiler :(
		if (tgen[b] == TCGEN_TEXTURE)
			st[b] = gl_MultiTexCoord0.st;
		if (tgen[b] == TCGEN_LIGHTMAP)
			st[b] = gl_MultiTexCoord1.st;
		if (tgen[b] == TCGEN_ENVIRONMENT_MAPPED)
		{	// u_parmtc = backEnd.or.viewOrigin
			vec3 viewer = normalize(u_parmtc - glVertex.xyz);
			float d = dot(gl_Normal, viewer);
			vec3 reflected = gl_Normal * 2.0 * d - viewer;
			st[b] = 0.5 + reflected.yz * 0.5;
		}
		if (tgen[b] == TCGEN_FOG)
		{
			st[b].s = dot(glVertex.xyz, u_fogDistanceVector.xyz) + u_fogDistanceVector.w;
			st[b].t = dot(glVertex.xyz, u_fogDepthVector.xyz) + u_fogDepthVector.w;
			if (u_eyeT < 0.0)
			{
				if (st[b].t < 1.0)
					st[b].t = 1.0/32.0;	// point is outside, so no fogging
				else
					st[b].t = 1.0/32.0 + 30.0/32.0 * st[b].t / ( st[b].t - u_eyeT );	// cut the distance at the fog plane
			}
			else
			{
				if (st[b].t < 0.0)
					st[b].t = 1.0/32.0;	// point is outside, so no fogging
				else
					st[b].t = 31.0/32.0;
			}
		}
		if (tgen[b] == TCGEN_VECTOR)
			st[b] = vec2( dot(glVertex.xyz, u_tcGenVectorS[b]), dot(glVertex.xyz, u_tcGenVectorT[b]) );

		// texMod (unrolled cycle for stupid ATI) TR_MAX_TEXMODS = 4
		float	f;
		bool	doit = true;
	// 1st tcMod:
		f = u_tcModParms[tcOffs++];
		if (f == GLSL_TMOD_NONE)
			doit = false;
		if (f == GLSL_TMOD_MATRIX)
		{
			vec2 sm = st[b];
			float pa, pb, pc, pd, pe, pf;
			pa = u_tcModParms[tcOffs++];
			pb = u_tcModParms[tcOffs++];
			pc = u_tcModParms[tcOffs++];
			pd = u_tcModParms[tcOffs++];
			pe = u_tcModParms[tcOffs++];
			pf = u_tcModParms[tcOffs++];
			st[b].s = dot(vec3(sm, 1.0), vec3(pa, pb, pc));
			st[b].t = dot(vec3(sm, 1.0), vec3(pd, pe, pf));
		}
		if (f == GLSL_TMOD_TURBULENT)
		{
			vec2 sm;
			float now = u_tcModParms[tcOffs++];
			float amplitude = u_tcModParms[tcOffs++];
			sm.x = sin(((glVertex.x + glVertex.z) * 0.125/128.0 + now) * 2.0 * 3.14159);
			sm.y = sin((glVertex.y * 0.125/128.0 + now) * 2.0 * 3.14159);
			st[b] += sm * amplitude;
		}
	// 2nd tcMod:
		if (doit)
		{
			f = u_tcModParms[tcOffs++];
			if (f == GLSL_TMOD_NONE)
				doit = false;
			if (f == GLSL_TMOD_MATRIX)
			{
				vec2 sm = st[b];
				float pa, pb, pc, pd, pe, pf;
				pa = u_tcModParms[tcOffs++];
				pb = u_tcModParms[tcOffs++];
				pc = u_tcModParms[tcOffs++];
				pd = u_tcModParms[tcOffs++];
				pe = u_tcModParms[tcOffs++];
				pf = u_tcModParms[tcOffs++];
				st[b].s = dot(vec3(sm, 1.0), vec3(pa, pb, pc));
				st[b].t = dot(vec3(sm, 1.0), vec3(pd, pe, pf));
			}
			if (f == GLSL_TMOD_TURBULENT)
			{
				vec2 sm;
				float now = u_tcModParms[tcOffs++];
				float amplitude = u_tcModParms[tcOffs++];
				sm.x = sin(((glVertex.x + glVertex.z) * 0.125/128.0 + now) * 2.0 * 3.14159);
				sm.y = sin((glVertex.y * 0.125/128.0 + now) * 2.0 * 3.14159);
				st[b] += sm * amplitude;
			}
	// 3rd tcMod:
			if (doit)
			{
				f = u_tcModParms[tcOffs++];
				if (f == GLSL_TMOD_NONE)
					doit = false;
				if (f == GLSL_TMOD_MATRIX)
				{
					vec2 sm = st[b];
					float pa, pb, pc, pd, pe, pf;
					pa = u_tcModParms[tcOffs++];
					pb = u_tcModParms[tcOffs++];
					pc = u_tcModParms[tcOffs++];
					pd = u_tcModParms[tcOffs++];
					pe = u_tcModParms[tcOffs++];
					pf = u_tcModParms[tcOffs++];
					st[b].s = dot(vec3(sm, 1.0), vec3(pa, pb, pc));
					st[b].t = dot(vec3(sm, 1.0), vec3(pd, pe, pf));
				}
				if (f == GLSL_TMOD_TURBULENT)
				{
					vec2 sm;
					float now = u_tcModParms[tcOffs++];
					float amplitude = u_tcModParms[tcOffs++];
					sm.x = sin(((glVertex.x + glVertex.z) * 0.125/128.0 + now) * 2.0 * 3.14159);
					sm.y = sin((glVertex.y * 0.125/128.0 + now) * 2.0 * 3.14159);
					st[b] += sm * amplitude;
				}
	// 4th tcMod:
				if (doit)
				{
					f = u_tcModParms[tcOffs++];
///					if (f == GLSL_TMOD_NONE)
///						doit = false;
					if (f == GLSL_TMOD_MATRIX)
					{
						vec2 sm = st[b];
						float pa, pb, pc, pd, pe, pf;
						pa = u_tcModParms[tcOffs++];
						pb = u_tcModParms[tcOffs++];
						pc = u_tcModParms[tcOffs++];
						pd = u_tcModParms[tcOffs++];
						pe = u_tcModParms[tcOffs++];
						pf = u_tcModParms[tcOffs++];
						st[b].s = dot(vec3(sm, 1.0), vec3(pa, pb, pc));
						st[b].t = dot(vec3(sm, 1.0), vec3(pd, pe, pf));
					}
					if (f == GLSL_TMOD_TURBULENT)
					{
						vec2 sm;
						float now = u_tcModParms[tcOffs++];
						float amplitude = u_tcModParms[tcOffs++];
						sm.x = sin(((glVertex.x + glVertex.z) * 0.125/128.0 + now) * 2.0 * 3.14159);
						sm.y = sin((glVertex.y * 0.125/128.0 + now) * 2.0 * 3.14159);
						st[b] += sm * amplitude;
					}
				}

			}
		}
	}

	st0 = st[0];
	st1 = st[1];
}
